/*++

     Copyright (c) 1998 Microsoft Corporation

     Spec Web 98 ISAPI and ASP components implementation

     Module Name:
         fRootAd.h

     File handle cache header

--*/

#ifndef _ROOT_AD_H_
#define _ROOT_AD_H_

#include <windows.h>
// #include "define.h"

/*---------------------------------------------------------------------*
	RootAd

*/


// Custom AD file memory structure

typedef struct sCustomAd
{
	unsigned int AdDemographics;
	unsigned int Weightings;
	unsigned int MinMvalue;
	unsigned int ExTime;
} CustomAd, *pCustomAd;

class RootAd
{
private:
	
	int  customBufSize;
	int  numberOfAd;

	// functions

	unsigned int hexToInt(char *p, int len);
	bool parseUserRd(HANDLE h);
	bool parseCustomRd(HANDLE h);

public:

	RootAd();
	~RootAd();
	unsigned int * pUserPfBuf;			// pointer to a buffer for holding user personality file
	pCustomAd  pCustomAdBuf[360];		// pointer to a buffer for holding custom AD file
	int  userBufSize;
	bool initialize(char* pUserFile, char* pCustomFile);



};


#endif