
/*
 * Copyright (c) 2001 by Sun Microsystems, Inc.
 * All rights reserved
 *
 * Specweb99 dynamic content generation plugin
 *
 */

#pragma ident "@(#)dyn_get_cgi.c    1.0 01/03/04    SMI"



#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>

#define SPECWEBDIR "/docs99/spec"

#define TOPDIR SPECWEBDIR
#define BUFFER_LEN 1024*1024
#define PATH_MAX_LEN 256


#define FIRST_THINGS "<html>\n\
<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n\
<body>\n\
<p>SERVER_SOFTWARE = %s\n\
<p>REMOTE_ADDR = %s\n\
<p>SCRIPT_NAME = %s\n\
<p>QUERY_STRING = %s\n\
<pre>\n"

#define LAST_THINGS "\n</pre>\n</body></html>\n"

int main() 
{
	char *server_software;
	char *remote_addr;
	char *script_name;
	char *query_string;

	int fd;
	int buflen, len;
	struct stat st;

	char filename[PATH_MAX_LEN];

	char outbuf[BUFFER_LEN];
	int headlen = 0;

	server_software = getenv("SERVER_SOFTWARE");
	remote_addr = getenv("REMOTE_ADDR");
	script_name = getenv("SCRIPT_NAME");
	query_string = getenv("QUERY_STRING");

	headlen = sprintf(outbuf, FIRST_THINGS, 
					server_software, remote_addr,
					script_name, query_string);

	strcpy(filename, TOPDIR);
	/*strcat(filename, "/"); */
	strcat(filename, query_string);

	fd = open (filename, O_RDONLY);
	if (fd <0) {
		buflen = headlen + sprintf (outbuf+headlen, "Error opening file '%s'.\n", filename) -1 ;
	} else {
/*		fstat (fd, &st); */

		len = read (fd, outbuf+headlen, BUFFER_LEN);
		close(fd);

		if (len <= 0 ) {
			buflen = headlen + sprintf(outbuf+headlen, "Error (%d) reading file '%s'.\n", errno, filename)-1;
		}
		else 
			buflen = headlen + len; 
	}

	strncpy (outbuf+buflen, LAST_THINGS, sizeof(LAST_THINGS));
	buflen += sizeof(LAST_THINGS) - 1;

	printf ("Content-type: text/html\nContent-Length: %d\n\n", buflen);		
	fwrite (outbuf, sizeof (char), buflen, stdout);

}
