#ifndef _HTTPFILT_H
#define _HTTPFILT_H

/* $Id: httpfilt.h,v 1.1 1998/05/15 10:27:11 adam Exp $ */

/* This header file contains all the constants and types needed to write
   ISAPI filters.  This file will be given to API developers and is also
   included in the server source code.  Note: this file should contain
   only ANSI C, no C++ comments! */

#include "wintypes.h"


#define    HTTP_FILTER_MAJOR          2
#define    HTTP_FILTER_MINOR          0

#define    HTTP_FILTER_REVISION  MAKELONG( HTTP_FILTER_MINOR, HTTP_FILTER_MAJOR )

#define    SF_MAX_USERNAME            256
#define    SF_MAX_PASSWORD            256 
#define    SF_MAX_FILTER_DESC_LEN     256 


#define    SF_STATUS_TYPE                     0x8000000
#define    SF_STATUS_REQ_FINISHED             SF_STATUS_TYPE
#define    SF_STATUS_REQ_FINISHED_KEEP_CONN   SF_STATUS_TYPE + 1
#define    SF_STATUS_REQ_NEXT_NOTIFICATION    SF_STATUS_TYPE + 2
#define    SF_STATUS_REQ_HANDLED_NOTIFICATION SF_STATUS_TYPE + 3
#define    SF_STATUS_REQ_ERROR                SF_STATUS_TYPE + 4
#define    SF_STATUS_REQ_READ_NEXT            SF_STATUS_TYPE + 5

#define    SF_NOTIFY_SECURE_PORT              0x000001
#define    SF_NOTIFY_NONSECURE_PORT           0x000002
#define    SF_NOTIFY_READ_RAW_DATA            0x008000
#define    SF_NOTIFY_PREPROC_HEADERS          0x004000
#define    SF_NOTIFY_AUTHENTICATION           0x002000
#define    SF_NOTIFY_URL_MAP                  0x001000
#define    SF_NOTIFY_ACCESS_DENIED            0x000800
#define    SF_NOTIFY_SEND_RAW_DATA            0x000400
#define    SF_NOTIFY_LOG                      0x000200
#define    SF_NOTIFY_END_OF_NET_SESSION       0x000100


#define    SF_NOTIFY_ORDER_HIGH               0x080000
#define    SF_NOTIFY_ORDER_MEDIUM             0x040000
#define    SF_NOTIFY_ORDER_LOW                0x020000
#define    SF_NOTIFY_ORDER_DEFAULT            SF_NOTIFY_ORDER_LOW
#define    SF_NOTIFY_ORDER_MASK               SF_NOTIFY_ORDER_HIGH | \
                                              SF_NOTIFY_ORDER_MEDIUM | \
					      SF_NOTIFY_ORDER_LOW


/* TODO: these four need verifying - am fairly sure they're correct */
#define SF_REQ_SEND_RESPONSE_HEADER           0
#define SF_REQ_ADD_HEADERS_ON_DENIAL          1
#define SF_REQ_SET_NEXT_READ_SIZE             2
#define SF_REQ_SET_PROXY_INFO                 3

/* These are Zeus specific extensions */
#define SF_REQ_GET_FILE_DESCRIPTOR            2000

typedef struct _HTTP_FILTER_CONTEXT
{
   DWORD    cbSize;          /* the size of this structure */
   DWORD    Revision;        /* the revision number of this structure */
   PVOID    ServerContext;   /* reserved for server use */
   DWORD    ulReserved;      /* reserved for server use */
   BOOL     fIsSecurePort;   /* True if the connection is on a secure port */
   PVOID    pFilterContext;  /* a pointer to information the filter wants
                                to associate with the request */

   BOOL     (WINAPI * GetServerVariable) (struct _HTTP_FILTER_CONTEXT * pfc,
					  LPSTR      lpszVariableName,
					  LPVOID     lpvBuffer,
					  LPDWORD    lpdwSize);    
   BOOL (WINAPI * AddResponseHeaders)    (struct _HTTP_FILTER_CONTEXT * pfc,
 				         LPSTR    lpszHeaders,
				         DWORD    dwReserved);     
   BOOL (WINAPI * WriteClient)           (struct _HTTP_FILTER_CONTEXT * pfc,
				         LPVOID     Buffer,
                                         LPDWORD    lpdwBytes,
                                         DWORD      dwReserved);     
   VOID* (WINAPI * AllocMem)             (struct _HTTP_FILTER_CONTEXT * pfc,
			                 DWORD      cbSize,
			                 DWORD      dwReserved);    
   BOOL (WINAPI * ServerSupportFunction) (struct _HTTP_FILTER_CONTEXT * pfc,
					 DWORD   sfReq,
					 LPVOID pData,
					 LPDWORD ul1,
					 LPDWORD ul2);     
} HTTP_FILTER_CONTEXT, *PHTTP_FILTER_CONTEXT;



typedef struct _HTTP_FILTER_PREPROC_HEADERS
{
   BOOL    (WINAPI * GetHeader) (struct _HTTP_FILTER_CONTEXT *    pfc,
				 LPSTR    lpszName,
				 LPVOID   lpvBuffer,
				 LPDWORD  lpdwSize);     
   BOOL    (WINAPI * SetHeader) (struct _HTTP_FILTER_CONTEXT *    pfc,
				 LPSTR    lpszName,
				 LPSTR    lpszValue);      
   BOOL    (WINAPI * AddHeader) (struct _HTTP_FILTER_CONTEXT *    pfc,
				 LPSTR    lpszName,
				 LPSTR    lpszValue);      
   DWORD    dwReserved;     
} HTTP_FILTER_PREPROC_HEADERS, *PHTTP_FILTER_PREPROC_HEADERS;


typedef struct _HTTP_FILTER_AUTHENT
{
    CHAR *    pszUser;
    DWORD     cbUserBuff;
    CHAR *    pszPassword;
    DWORD     cbPasswordBuff;
} HTTP_FILTER_AUTHENT, *PHTTP_FILTER_AUTHENT;


typedef struct _HTTP_FILTER_ACCESS_DENIED
{
   const CHAR * pszURL;           /* Requesting URL */
   const CHAR * pszPhysicalPath;  /* Physical path of resource */
   DWORD        dwReason;         /* Bitfield of SF_DENIED flags */
} HTTP_FILTER_ACCESS_DENIED, *PHTTP_FILTER_ACCESS_DENIED;
 


typedef struct _HTTP_FILTER_VERSION
{
    DWORD     dwServerFilterVersion;
    DWORD     dwFilterVersion;
    CHAR      lpszFilterDesc[SF_MAX_FILTER_DESC_LEN+1];
    DWORD     dwFlags;
} HTTP_FILTER_VERSION, *PHTTP_FILTER_VERSION;
 

typedef struct _HTTP_FILTER_URL_MAP
{
    const CHAR *    pszURL;
    CHAR *          pszPhysicalPath;
    DWORD           cbPathBuff;
} HTTP_FILTER_URL_MAP, *PHTTP_FILTER_URL_MAP;

typedef struct _HTTP_FILTER_LOG
{
    const CHAR *    pszClientHostName;
    const CHAR *    pszClientUserName;
    const CHAR *    pszServerName;
    const CHAR *    pszOperation;
    const CHAR *    pszTarget;
    const CHAR *    pszParameters;
    DWORD           dwHttpStatus;
    DWORD           dwWin32Status;
} HTTP_FILTER_LOG, *PHTTP_FILTER_LOG;
 

typedef struct _HTTP_FILTER_RAW_DATA
{
    PVOID pvInData;
    DWORD cbInData;
    DWORD cbInBuffer;
    DWORD dwReserved;
} HTTP_FILTER_RAW_DATA, *PHTTP_FILTER_RAW_DATA;
 

#endif








