#!/usr/local/bin/perl
#
# usage 1: cgi GET
#    GET /spec/cgi-bin/specweb99-cgi.pl?/spec/file_set/dir<n>/class<x>_<y>
#
#  Simulates Ad Rotation.  If GET includes header: Cookie: mycookie=<value>
#  then "Customized Ad Rotation" processing is also performed.
#
# usage 2: cgi POST
#
#    POST /spec/cgi-bin/specweb99-cgi.pl
#    Content-length: <length>
#    
#    urlroot=/spec/file_set/&dir=<n>&class=<x>&num=<y>&client=<client_id>
#
#    ("key=val" are separated by a "&")
#
# usage 3: cgi GET for fileset management
#    GET /spec/cgi-bin/specweb99-cgi.pl?command/Reset
#    GET /spec/cgi-bin/specweb99-cgi.pl?command/Fetch
#
# $Id: specweb99-cgi.pl,v 1.3 1998/03/05 05:22:15 channui Exp $
#
# MC: Changed use of the USER_AGENT environment variable to SERVER_SOFTWARE.
#     USER_AGENT is the name client software and is sent as a header.  The
#     SPECweb99 code is not sending that header so it was always empty.
#     -Greg (11/3/97)
#
#     Changed to add support for "Customized Ad Rotation" using cookies.
#     POST enhanced to transmit SetCookie header.  Also added support
#     to handle Cookie header with GET to search post log for current 
#     "user" info and return page and header with matching record count.
#      -Paula (06/05/98)
#
#
#!/usr/local/bin/perl

###uncomment_for_fast-cgi### use FCGI;
use strict;
use Fcntl ':flock';

binmode STDOUT;		### Needed for NT

local(*FILE);
my ($file);

# This needs to point to the directory that contains "file_set"
# my $topdir ='/bench/docs/spec/file_set';
my $topdir  = '';
my $logfile = '/weblog/post.log';
my $output  = '';

my $cadfile = '';
my $upfile = '';

my $my_cookie = 0; ### Used with POST and GET w/Cookie processing
my $Last_ad = 0;
my $found = 0;     ### Used in GET w/Cookie search of post log
my $maxTime = 30;  ### number of seconds to search post log for "fresh" cookies
my $reclen = 139;  ### number of bytes in POST log record

my $last_time;
my $maxload = 0;
my $maxthread = 0;
my(@Ad_id, @AdDemographics, @Weightings, @Min_Match_Value, @Expiration);

###uncomment_for_fast-cgi### while(FCGI::accept() >= 0) {
$output  = '';

if ($topdir eq "") {
    for my $i (qw(DOCUMENT_ROOT)) {
	if (defined ($ENV{$i})) {
	    $topdir = $ENV{$i};
	    last;
	}
    }
}
if ($topdir eq "") {
    for my $i (qw(PATH_TRANSLATED SCRIPT_FILENAME)) {
	if (defined ($ENV{$i})) {
	    $topdir = $ENV{$i};
	    $topdir =~ s#[\\/][^\\/]*[\\/][^\\/]*$##;
	    last;
	}
    }
}
### $logfile="$topdir/post.log" if $logfile eq '';
$logfile="/weblog/post.log" if $logfile eq '';

sub printfile {
    my($file) = @_;
    my($tmp) = "";
    if (open(FILE, "<$file")) {
	while (<FILE>) {
	    $tmp .= $_;
	}
  	close (FILE);
    } else {
       $tmp .= "Error opening file '$file': $!";
    }
    return $tmp;
}


sub printfile2 {
    my($file) = @_;
    my($tmp) = "";
    if (open(FILE, "<$file")) {
	while (<FILE>) {
	    print;
	}
  	close (FILE);
    } else {
       $tmp .= "Error opening file '$file': $!";
    }
    return $tmp;
}

### CustomAdRotation: GET processing associated with Ad Rotation using Cookies
### 
###       The client will send a cookie which includes a user_id and a value
###       that represents the last Ad seen.  The CustomAdRotation will lookup
###       the user_id in the User.Personality File to obatin the demographics
###       associated with that user.  The Custom.Ads file then is searched
###       starting at last_Ad+1. The Custom.Ads file contains the demographics
###	  associated with each of 360 ads and weightings to apply to the 
###       demographics shared by the ad and the user to determine how good a 
###       receiptant of the ad the incoming user will be.
###
###       The CGI/API code will:
###                - calculate result of ( AdDemographics AND UserDemographics )
###                - apply the Weightings to calculate Ad_weight
###                - check if  Ad_weight >=  Minimum_Match_Value
###                - check the Ad_expiration field
###                - return Set-Cookie containing: 
###			Ad_id, Ad_weight, Expired_indicator
###                - and of course the html with the page indicated by our mix.
###
###

sub CustomAdRotation {

my ($Expired, $Ad_weight, $CadRecord);
my ($User_id, $UserDemographics, $UserRec);

my $UserRecLen = 15;
my $CadRecLen  = 39;

my $GENDER_MASK	   = 0x30000000 ;
my $AGE_GROUP_MASK = 0x0f000000 ;
my $REGION_MASK    = 0x00f00000 ;
my $INTEREST1_MASK = 0x000ffc00 ;
my $INTEREST2_MASK = 0x000003ff ;

my $cadfile = "$topdir/Custom.Ads" if $cadfile eq '';
my $upfile  = "$topdir/User.Personality" if $upfile eq '';



###CustomAdRotation:
###
###Begin:
###	Read in requested file for search/replace operation
###
my($scanfile) = @_;
my($reqdfile) = "";
my $merge = "";
if (open(FILE, "<$scanfile")) {
   while (<FILE>) {
      $reqdfile .= $_;
   }
   close (FILE);
} else {
   $reqdfile .= "Error opening file '$scanfile': $!";
}

###    Parse Cookie string into MyUser and Last_Ad. The format is as follows:
###        my_cookie=user_id=[MyUser]&last_ad=[Last_ad]
	# Following performed on entry 
	#$my_cookie = 0;
	#if($ENV{'HTTP_COOKIE'}) {
	#(my $junk1,my $uid,my $myc,$Last_ad) = split(/=/,$ENV{'HTTP_COOKIE'});
	#($my_cookie, my $la) = split(/&/,$myc);
	#}

	my $MyUser = $my_cookie;

###    MyUser = MyUser - 10000;
###    Find User.Personality record where MyUser == User_id
###    If no matching record is found
###        CookieString = "found_cookie=-1&Ad_weight=00&Expired=0
###        Return HTML Page with File=FileName and Cookie=CookieString
###    Endif
###    If Last_ad is invalid (not in range of 0..359)
###        CookieString = "found_cookie=-1&Ad_weight=00&Expired=1
###        Return HTML Page with File=FileName and Cookie=CookieString
###    Endif


    $MyUser = $MyUser - 10000;
    my $User_seek = $MyUser * $UserRecLen ;
    $found = sprintf "Ad_id=-1&Ad_weight=00&Expired=0" ;
    if (open (UPFILE, "$upfile")) {
        if ( sysseek (UPFILE, int($User_seek), 0) ) {
	    my $rr = sysread (UPFILE, $UserRec, $UserRecLen);
            if ( $rr  == $UserRecLen ) {
                ($User_id, $UserDemographics) = split ' ', $UserRec;
		$UserDemographics = hex($UserDemographics);
            } else {
    $found = sprintf "Ad_id=-7&Ad_weight=%d&Expired=%s",$MyUser,$UserRec ;
                return $found;
            }
        } else {
    $found = sprintf "Ad_id=-8&Ad_weight=00&Expired=0" ;
            return $found;
        }
        close (UPFILE);
    } else {
    $found = sprintf "Ad_id=-9&Ad_weight=00&Expired=0" ;
        return $found;
    }
    $found = sprintf "Ad_id=-10&Ad_weight=00&Expired=1" ;
    if ($Last_ad > 359 || $Last_ad < 0 ) {
	return $found;
    }


###  Set Ad_index = Last_ad+1
###  If Ad_index > 359 then
###     Ad_index = 0
###  Endif

    my $Ad_index = $Last_ad+1;
    if ( $Ad_index > 359 ) {
        $Ad_index = 0;
    }

###    Do For Each Ad in Custom.Ads starting where Ad_index == Ad_id
###        Retrieve the record
###        Parse Custom.Ads record into AdDemographics, Weightings,
###            Minimum_Match_Value, Expiration_Date
###        CombinedDemographics = ( AdDemographics & UserDemographics )
###        Ad_weight = 0
my $CombinedDemographics = 0;
my $Ad;

### Reload Custom.Ads file if needed

my ($dev, $ino, $mode, $nlink, $uid, $gid, $rdev, $size, $atime, $mtime, $ctime,$blksize, $blocks) = stat ($cadfile);

if ( $mtime > $last_time ) {
    $last_time = $mtime;
    $found = sprintf "Ad_id=-1&Ad_weight=00&Expired=2" ;
    if (open (CADFILE, "$cadfile")) {
        foreach $Ad (0..359) {
            my $Ad_seek = $Ad * $CadRecLen;
            if ( sysseek (CADFILE, int($Ad_seek), 0) ) {
                if ( sysread (CADFILE, $CadRecord, $CadRecLen) != $CadRecLen ) {
                    return $found;
                }
            } else {
                return $found;
            }
            ($Ad_id[$Ad], $AdDemographics[$Ad], $Weightings[$Ad], 
		$Min_Match_Value[$Ad], $Expiration[$Ad]) = 
		  split ' ', $CadRecord;
            $AdDemographics[$Ad] = hex ($AdDemographics[$Ad]);
            $Weightings[$Ad]     = hex ($Weightings[$Ad]);
	}
        close (CADFILE);
    } else {
	return $found;
    }
}

    foreach $Ad (0..359) {

        my $Gender_wt    = ( $Weightings[$Ad_index] & 0x000f0000 ) >> 16;
	my $Age_group_wt = ( $Weightings[$Ad_index] & 0x0000f000 ) >> 12;
	my $Region_wt    = ( $Weightings[$Ad_index] & 0x00000f00 ) >>  8;
	my $Interest1_wt = ( $Weightings[$Ad_index] & 0x000000f0 ) >>  4;
	my $Interest2_wt = ( $Weightings[$Ad_index] & 0x0000000f );

        $CombinedDemographics = ($AdDemographics[$Ad_index] & $UserDemographics);
        $Ad_weight = 0;

##D## if (open(DBGFILE,">>/tmp/sw99cgi.debug")) {
##D## printf DBGFILE "\n_%d: %d __%8X, %8X, %8X, %8X, %d, %d %d %d %d %d\n", $MyUser, $Ad_index, $AdDemographics[$Ad_index],$UserDemographics, $CombinedDemographics, $Weightings[$Ad_index], $Min_Match_Value[$Ad_index], $Gender_wt, $Age_group_wt, $Region_wt, $Interest1_wt, $Interest2_wt;
##D## close(DBGFILE);
##D## }

###     If ( CombinedDemographics & GENDER_MASK ) then
###             Ad_weight = Ad_weight + Gender_wt
###     Endif
        if ( $CombinedDemographics & $GENDER_MASK ) {
                $Ad_weight = $Ad_weight + $Gender_wt;
        }
###     If ( CombinedDemographics & AGE_GROUP_MASK ) then
###             Ad_weight = Ad_weight + Age_group_wt
###     Endif
        if ( $CombinedDemographics & $AGE_GROUP_MASK ) {
                $Ad_weight = $Ad_weight + $Age_group_wt;
        }
###     If ( CombinedDemographics & REGION_MASK ) then
###             Ad_weight = Ad_weight + Region_wt
###     Endif
        if ( $CombinedDemographics & $REGION_MASK ) {
                $Ad_weight = $Ad_weight + $Region_wt;
        }
###     If ( CombinedDemographics & INTEREST1_MASK ) then
###             Ad_weight = Ad_weight + Interest1_wt
###     Endif
        if ( $CombinedDemographics & $INTEREST1_MASK ) {
                $Ad_weight = $Ad_weight + $Interest1_wt;
        }
###     If ( CombinedDemographics & INTEREST2_MASK ) then
###             Ad_weight = Ad_weight + Interest2_wt
###     Endif
        if ( $CombinedDemographics & $INTEREST2_MASK ) {
                $Ad_weight = $Ad_weight + $Interest2_wt;
        }
###     If ( Ad_weight >= Minimum_Match_Value ) then
###             If current_time > Expiration_Date then
###                     Expired = True (1)
###             Else
###                     Expired = False (0)
###             Endif
###             Return (without linebreaks):
###                 "Set-Cookie: found_cookie=
###                 Ad_id=<Ad_index>&Ad_weight=<Ad_weight>&Expired=<Expired>"
###     Endif
	if ( $Ad_weight >= $Min_Match_Value[$Ad_index] ) {
	    my $currTime = time();
	    if ( $currTime > $Expiration[$Ad_index] ) {
		$Expired = 1;
	    } else {
		$Expired = 0;
	    }
            $found = sprintf 
		"Ad_id=%d&Ad_weight=%d&Expired=%d", 
		$Ad_id[$Ad_index], $Ad_weight, $Expired;
	    last;
	} 
###     Ad_index=Ad_index+1
###     If Ad_index > 359  then
###             Ad_index = 0
###     Endif
###     Continue Processing Custom.Ads records until Ad_index = Last_ad
###  Enddo
        $Ad_index++;
        if ($Ad_index > 359) {
            $Ad_index = 0;
        }
    }
###  Return (without linebreaks):
###    "Set-Cookie: found_cookie=
###    Ad_id=<Ad_index>&Ad_weight=<Ad_weight>&Expired=<Expired>"
###End
    my $currTime = time();
    if ( $currTime > $Expiration[$Ad_index] ) {
	$Expired = 1;
    } else {
	$Expired = 0;
    }
    $found = sprintf 
	"Ad_id=%d&Ad_weight=%d&Expired=%d", 
	$Ad_id[$Ad_index], $Ad_weight, $Expired;

#
# Process files in class1 and class2 to be returned looking for 1 or more 
# occurances of:
# "<!WEB99CAD><IMG SRC="/file_set/dirNNNNN/classX_Y"><!/WEB99CAD>"
# Convert Ad_id to a Directory number, class number and file in class
# number.  Result will be for file in first 10 directories
# Replace dirNNNNN/classX_Y with values derived from the Ad_id
# 
#

if ((index ($scanfile,"class1",0) != -1)||(index ($scanfile,"class2",0) != -1)){
    my $scan1 = "<!WEB99CAD><IMG SRC=\"/file_set/dir";
    my $scan2 = "NNNNN/class";
    my $scan3 = "X_";
    my $scan4 = "Y\"><!/WEB99CAD>";
    my $pos1 = -1;
    my $pos2 = -1;
    my $pos3 = -1;
    my $pos4 = -1;
    my $dirNNNNN   = sprintf("%05d", (int ($Ad_id[$Ad_index]/36)));
    my $classX     = sprintf("%01d", (int (($Ad_id[$Ad_index]%36)/9)));
    my $fileY      = sprintf("%01d", (int ($Ad_id[$Ad_index]%9)));
    my $overwrtfnm = $dirNNNNN . "/class" . $classX . "_" . $fileY ;
    my $ii = 0;
    my @overwritepts = ();
    my @overwritefnms = ();
    
    ##
    ## Find WEB99CAD strings and verify format
    ##
    while (($pos1 = index ($reqdfile, $scan1, $pos1)) > -1) {
       if ( (( $pos2 = index ($reqdfile, $scan2, $pos2)) > -1) &&
            (( $pos3 = index ($reqdfile, $scan3, $pos3)) > -1) &&
	    (( $pos4 = index ($reqdfile, $scan4, $pos4)) > -1) ) {
		     $overwritepts[$ii] = $pos2;
        }
        $pos1++;
        $pos2++;
        $ii++;
    }
    ##
    ## If WEB99CAD strings were found replace dirNNNNN/classX_Y with filename
    ## based on the Ad_id
    ##
    if ( $ii > 0 ) {
        my $start = 0;
        my $owflength = 0;
        my $j = 0;
        for ($j=0; $j < @overwritepts; $j++) {
            $merge .= substr ($reqdfile, $start, $overwritepts[$j]-$start);
            $owflength = 0;
            $merge .= $overwrtfnm;
            $owflength += length ($overwrtfnm);
            $start = length ($merge);
        }
        $merge .= substr ($reqdfile, $start, (length($reqdfile) - $start) );
    } else { 
        return $reqdfile; 
    }

} else {
    return $reqdfile;
}

        return $merge;
}
#########

sub testlock {
    my $tmp = "";
    if (open(FILE, "+<$logfile")) {
        $tmp .= sprintf "lock %d<br>\n", time;
	flock(FILE,LOCK_EX);
        $tmp .= sprintf "sleep %d<br>\n", time;
        sleep (5);
        $tmp .= sprintf "unlock %d<br>\n", time;
	flock(FILE,LOCK_UN);
        $tmp .= sprintf "close %d<br>\n", time;
	close(FILE);
    } else {
        $tmp .= "Can't open file '$logfile': $!\n";
    }
    return $tmp;
}


# some servers may require
# Content-type: text/html
# followed by a blank line

again:

$output .= "<html>\n";
$output .= "<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n";
$output .= "<body>\n";
$output .= "<p>SERVER_SOFTWARE = $ENV{'SERVER_SOFTWARE'}\n";
$output .= "<p>REMOTE_ADDR = $ENV{'REMOTE_ADDR'}\n";
$output .= "<p>SCRIPT_NAME = $ENV{'SCRIPT_NAME'}\n";
$output .= "<p>QUERY_STRING = $ENV{'QUERY_STRING'}\n";
$output .= "<pre>\n";

### Obtain cookie name=value pair from enviroment variable ###
### Maybe part of GET or POST request			   ###

$my_cookie = 0;
if($ENV{'HTTP_COOKIE'}) {
#(my $junk1, $my_cookie) = split(/=/,$ENV{'HTTP_COOKIE'});
(my $junk1, my $uid, my $myc, $Last_ad) = split(/=/,$ENV{'HTTP_COOKIE'});
($my_cookie, my $la) = split(/&/,$myc);
}


if ($topdir eq "") {
    $output .= "Can't find top of document tree, please configure value CGI script manually.\n";
   } elsif ($ENV{'REQUEST_METHOD'} eq "GET") {

      #-----------------------
      # REQUEST_METHOD:  GET  
      #-----------------------

      if ($ENV{'QUERY_STRING'}) {
        my $qs = $ENV{'QUERY_STRING'};
	$file = $ENV{'QUERY_STRING'};
	chomp($file); chomp($file);
	if ($file =~ m#command/Reset#) {
	my ($cmdreset,$mls,$maxld,$pls,$pttime,$mts,$maxthrd,$es,$exp) = 
	 split(/[\&=]/,$qs);
        $maxload = $maxld;
        $maxthread = $maxthrd;

	unlink($cadfile);
	unlink($upfile);

        my $cmd1="$topdir/upfgen99 -C $topdir -n $maxload -t $maxthread ";
        $exp =~ s/,/ /g;
        my $cmd2 = "$topdir/cadgen99 -C $topdir -e $pttime -t $maxthread $exp " ;
        my $stat1 = system "$cmd1";
        my $stat2 = system "$cmd2";

            # Reset will truncate the file, we unlink and then touch the file
	    unlink($logfile);
	    if (open(FILE,">$logfile")) {
		printf FILE "%10d\n", 0;
		close(FILE);
	    } else {
		$output .= "Error creating log file '$logfile': $!";
	    }
	    
	} elsif ($file =~ m#command/Fetch$#) {
            # Just return the logfile
	    #$output .= printfile($logfile);
	    my $header_len = length($output);
	    my $trailer_len = length("\n</pre>\n</body></html>\n");
            my ($dev, $ino, $mode, $nlink, $uid, $gid, $rdev, $size, $atime, $mtime, $ctime,$blksize, $blocks) = stat ($logfile);
	    my $len = $header_len + $size + $trailer_len;

#open(FILE, "+<$logfile");
#printf FILE "%10d", $size/139;
#close(FILE);

	    print "Content-type: text/html\nContent-Length: $len\n\n$output";
	    printfile2 ($logfile);
	    print "\n</pre>\n</body></html>\n";
	} elsif ($file =~ m#command/Test$#) {
	    $output .= testlock();
	} elsif ($file =~ m#command/Root$#) {
            # Just return the logfile
	    $output .= "The Document root of this server is '$topdir'\n";
	} else {

	    ### If cookie header included with GET do CustomAdRotation ###
            if ($my_cookie != 0) {
	       ##$output .= printfile("$topdir$file");
	       ###$output .= ProcessWebinc("$topdir$file");	
	       $output .= CustomAdRotation ("$topdir$file");
	    } else {
	       $output .= printfile("$topdir$file");	
	    }
        }
     } else {
       # QUERY STRING is needed for GET
       $output .= "QUERY STRING not set!\n";
     }
   } elsif ($ENV{'REQUEST_METHOD'} eq "POST") {

        #-----------------------
        # REQUEST_METHOD:  POST 
        #-----------------------

        my (%input, @input, $input, $key, $val);
	read(STDIN,$input,$ENV{'CONTENT_LENGTH'});
	@input = split(/&/,$input);
        foreach my $i (0 .. $#input) {
           ($key, $val) = split(/=/,$input[$i],2); 
           # Associate key and value. 
           # Assume the key is unique. Check for missing keys later.
           $input{$key} = $val;
        }

        if (!defined($input{'urlroot'}) || !defined($input{'dir'}) ||
              !defined($input{'class'}) || !defined($input{'num'}) ||
              !defined($input{'client'}) ) {
           $output .= "Incorrect POST Input: '$input'\n";
	   $output .= "POST Content-length: $ENV{'CONTENT_LENGTH'}\n";
	   $output .= "POST does not contain complete pathname and client information.\n"
        } else {
	  my $dir   = sprintf("%05d", $input{'dir'});
	  my $class = sprintf("%01d", $input{'class'});
	  my $num   = sprintf("%01d", $input{'num'});
	  my $client= sprintf("%10d", $input{'client'});
	  $file  = $input{'urlroot'}."dir".$dir."/class".$class."_".$num;

	  if (open(FILE, "+<$logfile")) {
		my $count;
		my $ts = time;
		my $pid = $$; # Or thread id
                # Need to lock file to make sure log is consistant
		flock(FILE,LOCK_EX);
		sysread(FILE,$count,10);
		$count = sprintf("%10d", ++$count);
		sysseek(FILE, 0, 0);
		syswrite(FILE,$count,10);
		sysseek(FILE, 0, 2);
		
		### Add user's cookie value to POST log for future reference ###
		my $tmp = sprintf "%10d %10d %10d %5d %2d %2d %10d %-60.60s %10d %10d\n", $count, $ts, $pid, $dir, $class, $num, $client, $file, $pid, $my_cookie;
		syswrite(FILE,$tmp,length $tmp);
		flock(FILE,LOCK_UN);
		close(FILE);
		$output .= printfile("$topdir$file");
	  } else {
		$output .= "Error opening log file '$logfile': $!\n";
	  }
	}
    } else {
	# Neither a GET nor POST request
    }

$output .= "\n</pre>\n</body></html>\n";
my $len = length($output);

### Return Content-Length header and 
### For POST return the Set-Cookie my_cookie=value  header along with page ###
### For GET w/ cookie return Set-Cookie found_cookie=value header with page ###

if ($ENV{'REQUEST_METHOD'} eq "POST") {
    print "Set-Cookie: my_cookie=$my_cookie\nContent-type: text/html\nContent-Length: $len\n\n$output";
    $my_cookie = 0;
}elsif ($my_cookie != 0) {
    print "Set-Cookie: found_cookie=$found\nContent-type: text/html\nContent-Length: $len\n\n$output";
    $found = 0;
}else { # GET
    print "Content-type: text/html\nContent-Length: $len\n\n$output";
}

###uncomment_for_fast-cgi### }

# end
