/*
 * zeus-get.c - implementation of SPECweb99 GET (static file fetch)
 * as an ISAPI extension. Optimised for Zeus Web Server 3.3.7
 *
 * (c) Zeus Technology Limited 2000-2001.  All rights reserved.
 * 
 * Copyright in the source code ("the Source Code") listed below in whatever
 * form, whether printed electronic compiled or otherwise, belongs to Zeus
 * Technology Limited ("we"/"us").
 * 
 * If you have entered into a written agreement with us under which the Source
 * Code is licensed to you ("Licence"),  you may not use, sell, license,
 * transfer, copy or reproduce the Source Code in whole or in part or in any
 * manner or form other than in accordance with your Licence.  To do so is
 * strictly prohibited and may be unlawful and a serious criminal offence.
 * 
 * If you have not entered into a Licence, disclosure of the Source Code is
 * made "as is".   You may use the Source Code for non-commercial purposes
 * only.  You may distribute the Source Code to individual third parties for
 * their non-commercial purposes only, but only if (1) you acknowledge our web
 * site as the source of the Source Code and include such acknowledgement and
 * our web address (www.zeus.com) in any copy of the Source Code; (2) the
 * Source Code you distribute is complete and not modified in any way and
 * includes this notice; and (3) you inform such third parties that these
 * conditions apply to them and that they must comply with them.
 * 
 * If you have not entered into a Licence, all express and implied warranties,
 * conditions, terms, undertakings and representations, including without
 * limitation as to quality, performance, fitness for purpose, or
 * non-infringement, are excluded to the fullest extent permitted by law.
 * Neither we nor any other person involved in disclosing the Source Code shall
 * have any liabilities whatsoever to you, howsoever arising, in connection
 * with the Source Code, or its use by you.
 * 
 * If you have not entered into a Licence but would like to do so,  please
 * contact us at pepp@zeus.com.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <time.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "httpext.h"
#define DEBUG_NAME "GET: "
#include "debug.h"
#include "zeus-common.h"

/* ----------------------------------------------------------------------
 * This is a 'static file fetch' - via an ISAPI request.
 * This is the simplest request of all - we don't need to do anything
 * other than tell the webserver to send the file. Use TRANSMIT_FILE
 * on the ServerSupportfunction hook to achieve this.
 * -------------------------------------------------------------------- */
void
process_request( LPEXTENSION_CONTROL_BLOCK ecb, request_t *request )
{
   HSE_TF_INFO tf;

   strcpy( path_tail, ecb->lpszQueryString );

   tf.pfnHseIO      = 0;  /* these must be 0 for Zeus */
   tf.pContext      = 0;
   tf.hFile         = (HANDLE) path_root;
   tf.pszStatusCode = "HTTP 200 OK\nContent-Type: text/html\n";
   tf.BytesToWrite  = 0; /* write all of file - could specify a portion of */
   tf.Offset        = 0; /*                     the file to send here      */
   tf.pHead         = (PVOID)request->header;
   tf.HeadLength    = request->headerlen;
   tf.pTail         = (PVOID)request->trailer;
   tf.TailLength    = request->trailerlen;
   /*
    * Because we are not going to be sending any more data after this,
    * we set HSE_IO_DISCONNECT_AFTER_SEND to let the webserver know, and
    * because we are also generating headers, we can use this information
    * to insert a Content-Length & hence use HTTP KeepAlive for better
    * performance.
    */
   tf.dwFlags = HSE_IO_SEND_HEADERS | HSE_IO_DISCONNECT_AFTER_SEND |
      HSE_IO_HANDLE_IS_FILENAME;

#ifdef OUT_PROCESS
   if ( out_process_transmitfile( ecb, request, &tf ) == TRUE ) return;
#else
   if ( ecb->ServerSupportFunction( ecb->ConnID, HSE_REQ_TRANSMIT_FILE,
                                    &tf, 0, 0 ) == TRUE ) return;
#endif

   /* the above failed - abort this spec run! */
   isapi_error( ecb, request,
		DEBUG_NAME "process_file_get_request: TRANSMIT_FILE failed" );
}

/* ----------------------------------------------------------------------
 * The following functions are called when this ISAPI module is
 * loaded / unloaded. Note that we don't actually need to do anything
 * special in this module.
 * -------------------------------------------------------------------- */
void
zeus_isapi_init( void )
{
}

void
zeus_isapi_exit( void )
{
}
