/*
 * Implementation of ISAPI code for SPECweb99, optimised
 * for Zeus Web Server 3.3.8 and above
 *
 * (c) Zeus Technology Limited 2000-2002.  All rights reserved.
 * 
 * Copyright in the source code ("the Source Code") listed below in whatever
 * form, whether printed electronic compiled or otherwise, belongs to Zeus
 * Technology Limited ("we"/"us").
 * 
 * If you have entered into a written agreement with us under which the Source
 * Code is licensed to you ("Licence"),  you may not use, sell, license,
 * transfer, copy or reproduce the Source Code in whole or in part or in any
 * manner or form other than in accordance with your Licence.  To do so is
 * strictly prohibited and may be unlawful and a serious criminal offence.
 * 
 * If you have not entered into a Licence, disclosure of the Source Code is
 * made "as is".   You may use the Source Code for non-commercial purposes
 * only.  You may distribute the Source Code to individual third parties for
 * their non-commercial purposes only, but only if (1) you acknowledge our web
 * site as the source of the Source Code and include such acknowledgement and
 * our web address (www.zeus.com) in any copy of the Source Code; (2) the
 * Source Code you distribute is complete and not modified in any way and
 * includes this notice; and (3) you inform such third parties that these
 * conditions apply to them and that they must comply with them.
 * 
 * If you have not entered into a Licence, all express and implied warranties,
 * conditions, terms, undertakings and representations, including without
 * limitation as to quality, performance, fitness for purpose, or
 * non-infringement, are excluded to the fullest extent permitted by law.
 * Neither we nor any other person involved in disclosing the Source Code shall
 * have any liabilities whatsoever to you, howsoever arising, in connection
 * with the Source Code, or its use by you.
 * 
 * If you have not entered into a Licence but would like to do so,  please
 * contact us at pepp@zeus.com.
 */

#ifndef _ZEUS_COMMON_H
#define _ZEUS_COMMON_H

#include "wintypes.h"
#include "httpext.h"

enum { Success=0, Failure };

typedef struct {
   char *header;
   int headerlen;
   char *trailer;
   int trailerlen;
#ifdef OUT_PROCESS
   char local_path_root[512];
   char *local_path_tail;
#endif
} request_t;

#ifdef OUT_PROCESS
#define path_root (request->local_path_root)
#define path_tail (request->local_path_tail)
#define in_static
#else
#define path_root global_path_root
#define path_tail global_path_tail
#define in_static static
#endif

/* these are filled in when the module is loaded */
extern const char zeus_home[];  /* where $ZEUSHOME is set to                */
#ifndef OUT_PROCESS
extern char global_path_root[]; /* example: /space/specweb                  */
extern char *global_path_tail;  /*   points to the end of path_root         */
#endif
extern char POST_LOGFILE[];     /* example: /space/specweb/post.log         */
extern char UPF_PATH[];         /* example: /space/specweb/User.Personality */
extern char CAD_PATH[];         /* example: /space/specweb/Custom.Ads       */

#define SMALL_BUFFER 32
#define MEDIUM_BUFFER 256
#define LARGE_BUFFER 512

void process_request(LPEXTENSION_CONTROL_BLOCK ecb, request_t *request);
int zeus_isapi_init(void);
void zeus_isapi_exit(void);

void isapi_error( LPEXTENSION_CONTROL_BLOCK ecb, request_t *request,
                  const char *msg, ... );

int zeus_readall( int fd, char *buf, int len );
int zeus_writeall( int fd, char *buf, int len );

#ifdef OUT_PROCESS
int out_process_transmitfile( LPEXTENSION_CONTROL_BLOCK ecb,
                              request_t *request, HSE_TF_INFO *tf );
#endif

#endif /* _ZEUS_COMMON_H */
