#ifdef WIN32
#include "Win32/mc-win32-config.h"
#else
#include <config.h>
#endif /* WIN32 */
#include "client.h"

#if defined(HAVE_PTHREAD_H) && defined(USE_POSIX_THREADS)
#include <pthread.h>
#endif
#if defined(HAVE_WINSOCK_H)
#include <winsock2.h>
#endif
#if defined(HAVE_IO_H)
#include <io.h>
#endif
#if defined(HAVE_STDLIB_H)
#include <stdlib.h>
#endif
#if defined(HAVE_UNISTD_H)
#include <unistd.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
#include <sys/types.h>
#endif
#if defined(HAVE_SYS_SOCKET_H)
#include <sys/socket.h>
#endif
#if defined(HAVE_MEMORY_H)
#include <memory.h>
#endif
#if defined(HAVE_STRING_H)
#include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
#include <strings.h>
#endif
#if defined(HAVE_NETDB_H)
#include <netdb.h>
#endif
#if defined(HAVE_NETINET_TCP_H)
#include <netinet/tcp.h>
#endif
#if defined(HAVE_NETINET_IN_H)
#include <netinet/in.h>
#endif
#if defined(HAVE_ERRNO_H)
#include <errno.h>
#endif
#if defined(HAVE_WINDOWS_H)
#include <windows.h>
#endif /* WIN32 */

extern void *Host_lock;
extern cl_options_t options;

static char *HT_c_rcsid = "$Id: HT.c,v 1.11 1998/03/11 00:38:54 channui Exp $";

#include "util.h"

#include "HT.h"
#include "HTParse.h"
#include "tcp.h"


#define DYNAMIC_GET

static void get_host_port(char *, char **, int *);
static int assign_port_number(http_info * http);


#ifdef WIN32
#define PRINT_ERR_LINENO	fprintf(stderr, "runtime error in %s line %d neterr = %d\n", __FILE__, __LINE__, WSAGetLastError())
#else
#define PRINT_ERR_LINENO	fprintf(stderr, "runtime error in %s line %d neterr = %d\n", __FILE__, __LINE__, errno);
#endif /* WIN32 */

int HTLoadHTTP (http_info *http) {
    int status;
    int done = 0;

    while (!done) 
    {
        http->isoc->input_pointer = http->isoc->input_limit = 
    	http->isoc->input_buffer;
#ifdef HTTPS_SUPPORT
        /* if KA connection is completed set ssl session state to done */
        if (http->connect == 0 && http->fin_sess == 2) {
                http->fin_sess = 1;
        }
#endif
        status = HTTPDoConnect(http);
        if (status >= 0)
        {
            status = HTTPSendRequest(http);
            if (status >= 0)

                status = HTTPGetReply(http);

		/*
                 * MC: a return status of 0 means that the the server closed 
		 *     a previous HTTP1.0 "Keep-Alive" connection.  We were
		 *     not able to detect that close until the read() called
                 *     by HTTPGetReply().  So we just close this socket, open
                 *     a new one, and try this URL again.
                 */
                if (status != 0)
                    done = 1;
/***             LOG(LOG_HTTP|LOG_STDERR, "HTLoadHTTP(): keepalive=%d; connect=%d sockfd=%d\n", http->request->keep_alive, http->connect, (int) http->sockfd); ***/
        }
        else
            http->connect = 0; /* MC: to avoid reuse of bad connection */
        (void) HTTPCleanup(http);
    }
    return status;
}

int HTTPDoConnect ( 
    http_info * http
)
{
    char *host_port;
    char *host;
    int port;
    struct hostent *hostelement;
    SockA sock_addr;                            /* SockA is defined in tcp.h */
    int status;
    int tcpnodelay;
#ifdef EXPLICIT_BIND
    int numtries;
#endif /* EXPLICIT_BIND */

double now_time, next_time;

    LOG(LOG_HTTP, "HTTPDoConnect: enter\n");

    LOG(LOG_HTTP, "HTTPDoConnect(): keepalive=%d (connect=%d) for sock %d\n", http->request->keep_alive, http->connect, (int) http->sockfd);/*KA*/

    if (http->connect > 0) {
	int rc;
	struct timeval tv;
	fd_set rin, win, ein;

	FD_ZERO(&rin); FD_ZERO(&win); FD_ZERO(&ein);
	FD_SET(http->sockfd, &rin);
        tv.tv_sec = tv.tv_usec = 0; /* poll */

	rc = select(http->sockfd+1, &rin, NULL, NULL, &tv);
	if (rc > 0 && FD_ISSET(http->sockfd, &rin)) {
	    char buf[2];
	    rc = recv(http->sockfd, buf, 1, 0);
	    if (rc == 0) {
		LOG(LOG_HTTP, "HTTPDoConnect(): server closed socket?\n");
		http->connect = 0;
		HTTPCleanup (http);
	    } else {
		/* This is actually an error, because there shouldn't be
		   any data on the pipe at this point.  Perhaps we
		   should log it as such? */
		LOG(LOG_HTTP, "HTTPDoConnect(): error: early data on connection\n");
		
		return 1;
	    }
	} else {
	    return 1;
	}
    }

    http->connect = http->request->keep_alive;
LOG(LOG_HTTP, "HTTPDoConnect(): connect=keep_alive = %d\n", http->connect);

    host_port = HTParse(http->request->url, "", PARSE_HOST);
    LOG(LOG_HTTP, "HTDoConnect: host_port = %s\n", host_port);
    get_host_port(host_port, &host, &port);
    strcpy(http->host, host);
    free(host_port);

    memset((void *) &sock_addr, '\0', sizeof(sock_addr));
    sock_addr.sin_family = AF_INET;
    if (port > 0) {
        sock_addr.sin_port = htons((short)port);
    } else {
#ifdef HTTPS_SUPPORT
	sock_addr.sin_port = htons((short) 443);
#else
	sock_addr.sin_port = htons((short) 80);
#endif
    }

    LOG(LOG_HTTP, "HTDoConnect: host = %s port = %d\n", host, ntohs(sock_addr.sin_port));

#ifdef WIN32
    if ((http->sockfd = WSASocket(AF_INET, SOCK_STREAM, IPPROTO_TCP, NULL, 0, WSA_FLAG_OVERLAPPED)) == INVALID_SOCKET)
#else
    if ((http->sockfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
#endif
    {
	LOG(LOG_HTTP|LOG_STDERR, "HTDoConnect: No socket (%d)\n", errno);

        return -1;
    }
    http->isoc->input_file_number = http->sockfd;
    tcpnodelay = 1;
    if (setsockopt(http->sockfd, IPPROTO_TCP, TCP_NODELAY,
	    (char *) &tcpnodelay, sizeof(tcpnodelay)) < 0) {
	LOG(LOG_HTTP|LOG_STDERR, 
	    "HTDoConnect: Can't set sockopt TCP_NODELAY (%d)\n", errno);
        return -1;
    }
    if (http->request->abortive_close > 0) {
#ifdef WIN32
        /*
         * MC: Like many versions of UNIX, Windows defines its own struct linger
         *     (using unsigned shorts rather than ints) so use that instead.
         */
        struct linger lo;
        lo.l_onoff = 1;
        lo.l_linger = 0;
#else
	struct {
	    int on;
	    int linger;
	} lo;
	lo.on     = 1;
	lo.linger = 0;
#endif /* WIN32 */
	if (setsockopt(http->sockfd, SOL_SOCKET, SO_LINGER,
		(char *) &lo, sizeof(lo)) < 0) {
	    LOG(LOG_HTTP|LOG_STDERR, 
		"HTDoConnect: Can't set sockopt SO_LINGER (%d)\n", errno);
	    return -1;
	}
    }

#ifdef EXPLICIT_BIND
    /* explicitly bind the socket to a port */
    if ((numtries = assign_port_number(http)) < 0) {
	return -1;
    } else {
	if (numtries > 10)
	    LOG(LOG_INFO, "Warning.  It took %d tries to assign a port to the socket\n", numtries);
    }
#endif /* EXPLICIT_BIND */

#ifdef HAVE_GETHOSTBYNAME_R
/* I'm pretty sure this will only work with AIX, we can ifdef in other
   vendors as well */
    {
/*Changed by Pallab*/
#if (defined(SGI) || defined(__sun))
#       define LOCALBUFLEN      16384
        struct hostent hostelementdata;
        char    he_data[LOCALBUFLEN];
        int     h_errno;
        hostelement=&hostelementdata;
        memset(&he_data, 0, LOCALBUFLEN);
#ifdef __sun
        if (gethostbyname_r(host, hostelement, he_data, LOCALBUFLEN, &h_errno)
          == 0) {
            LOG(LOG_HTTP|LOG_STDERR,
                "HostByName.. Can't find internet node name `%s': (%d).\n",
                host, h_errno);
#else
        if (gethostbyname_r(host, hostelement, he_data, LOCALBUFLEN, &h_errno)
          != 0) {
            LOG(LOG_HTTP|LOG_STDERR,
                "HostByName.. Can't find internet node name `%s': %s.\n",
                host, hstrerror(h_errno));
#endif
            free(host);
            return -1;
        }
#else
	struct hostent hostelementdata;
	struct hostent_data he_data;
	hostelement=&hostelementdata;
	memset(&he_data, 0, sizeof(he_data));
	if (gethostbyname_r(host, hostelement, &he_data) != 0) {
	    LOG(LOG_HTTP|LOG_STDERR, 
		"HostByName.. Can't find internet node name `%s': (%d).\n", 
		host, h_errno);
	    free(host);
	    return -1;		
	}
#endif
        memcpy(&sock_addr.sin_addr,
            hostelement->h_addr,
            hostelement->h_length
        );
    }
#else
#ifndef GETHOSTBYNAME_MT_SAFE
    MutexLock(Host_lock);
#endif
    if ((hostelement = gethostbyname(host)) == NULL) {
	LOG(LOG_HTTP|LOG_STDERR, 
	    "HostByName.... Can't find internet node name `%s': (%d).\n", 
	    host, h_errno);
	free(host);
#ifndef GETHOSTBYNAME_MT_SAFE
    MutexUnlock(Host_lock);
#endif
	return -1;		
    }
    free(host);
    memcpy(&sock_addr.sin_addr,
        hostelement->h_addr,
        hostelement->h_length
    );
#ifndef GETHOSTBYNAME_MT_SAFE
    MutexUnlock(Host_lock);
#endif
#endif /* HAVE_GETHOSTBYNAME_R */

    status = connect(http->sockfd, (struct sockaddr *) &sock_addr,
	sizeof(sock_addr));

    LOG(LOG_HTTP, "HTDoConnect: leave; status = %d: \n", status);

#ifdef WIN32
    if (status == SOCKET_ERROR)
        LOG(LOG_HTTP|LOG_STDERR, "HTDoConnect: Can't connect (%d)\n", WSAGetLastError());
#else
    if (status < 0)
	LOG(LOG_HTTP|LOG_STDERR, "HTDoConnect: Can't connect (%d)\n", errno);
#endif /* WIN32 */


#ifdef HTTPS_SUPPORT

   /* make sure connection worked */
   if (status >= 0) {

    if (http->ctx_initd == 1) {
        /* create a new SSL structure to hold data for SSL connection, 
           inherit settings of the underlying context ctx: connection 
           method (SSLv2/v3/TLSv1), options, verification settings, timeout 
           settings. 
        */

        http->ssl = SSL_new(http->ctx);
        if (http->ssl == NULL) 
	    LOG(LOG_HTTP|LOG_STDERR, "HTTPDoConnect: SSL_new error: %s\n", 
	        ERR_error_string(ERR_get_error(), NULL));

    }


/*  Experimental: This section uses some criteria to shutdown the SSL session 
    and start a new one.  
*/
#ifdef HTTPS_SESSION_CONTROL
#ifdef USE_END_OF_KA_SESSION
    if (http->fin_sess == 1)  
#elif USE_COUNT_OF_CONNS
    if (http->session_cntrl == HTTPS_CONNS_PER_SESSION) 
#endif
    {

/*	SSL_set_shutdown(http->ssl, SSL_SENT_SHUTDOWN); */
	if ( 0 == (status = SSL_clear(http->ssl)) ) {
	    LOG(LOG_HTTP|LOG_STDERR,
              "HTTPDoConnect: SSL_clear error: status: %d,%s\n",
                status, ERR_error_string(ERR_get_error(), NULL));
	}
	
	 /* SSL_renegotiate(http->ssl); */
	 http->ssl->session->not_resumable=1;
         LOG(LOG_HTTP, "HTTPDoConnect: SSL_renegotiate \n"); 

#ifdef USE_END_OF_KA_SESSION
        if ( http->fin_sess == 1 ) http->fin_sess = 0;  
#elif USE_COUNT_OF_CONNS
	http->session_cntrl = 0;
#endif
    }
#endif
    
    /* setup socket file descriptor for ssl */
    if (SSL_set_fd(http->ssl, http->sockfd) == 0) 
	LOG(LOG_HTTP|LOG_STDERR, "HTTPDoConnect: SSL_set_fd error: %s\n", 
	    ERR_error_string(ERR_get_error(), NULL));

    /* get newly allocated BIO for ssl socket; close socket if BIO is freed */

    http->sbio = BIO_new_socket(http->sockfd, BIO_CLOSE); 
    if (http->sbio == NULL) 
	LOG(LOG_HTTP|LOG_STDERR, "HTTPDoConnect: BIO_new_socket error: %s\n", 
	    ERR_error_string(ERR_get_error(), NULL));



    /* connects the SSL object with the BIOs */

    SSL_set_bio (http->ssl, http->sbio, http->sbio); 


    /*  initiates the SSL handshake with a server; after ssl and bio setup. */
    if (SSL_connect(http->ssl) <= 0)
        LOG(LOG_HTTP|LOG_STDERR, "HTDoConnect: SSL_connect error: %s\n",
	    ERR_error_string(ERR_get_error(), NULL));

    /* Get pointer to SSL_SESSION which contains all info needed to 
       re-establish the connection without a new handshake */ 
    http->session = SSL_get_session(http->ssl);
    http->ctx_initd++;  /* increment !=1 so new SSL session not created */
    http->session_cntrl++;

    LOG(LOG_HTTP, "HTDoConnect: http->ctx_initd = %d\n",http->ctx_initd);
    LOG(LOG_HTTP, "HTDoConnect: http->session_cntrl=%d\n",http->session_cntrl);
    LOG(LOG_HTTP, "HTDoConnect: http->connect = %d\n",http->connect);
    LOG(LOG_HTTP, "HTDoConnect: http->sockfd  = %d\n",http->sockfd);
    LOG(LOG_HTTP, "HTDoConnect: http->ssl     = %#x\n",http->ssl);
    LOG(LOG_HTTP, "HTDoConnect: http->sbio    = %#x\n",http->sbio);
    LOG(LOG_HTTP, "HTDoConnect: http->session = %#x\n",http->session);
}

#endif

    return status;
   
}

#define CONN_COMMAND "Connection: Keep-Alive"
#define ACCEPT_COMMAND "Accept: */*"
#define ACCEPT_COMMAND_POST "Content-type: application/x-www-form-urlencoded\r\nAccept: */*"
#define NOCACHE_PRAGMA "Pragma: no-cache"
#define NOCACHE_CCONTROL "Cache-Control: no-cache"

int HTTPSendRequest (
    http_info * http
)
{
    int status = 0;
    char *path;
    char httpver[32];
    int content_length = 0;
    int error = 0;

    char *method;
    char buf[1024], *bufp = buf;

    if (http->connect > 0) {
        http->connect --;
#ifdef HTTPS_SUPPORT
        /* if KA connection is completed set ssl session state to done */
	if (http->connect == 0) {
		http->fin_sess = 2;
	}
#endif
    }    

    if (http->request->method != METHOD_INVALID) {
	method = HTMethod_name(http->request->method);
        if (http->request->method == METHOD_POST) {
            content_length=strlen(http->request->postdata);
            LOG(LOG_HTTP, "HTSendRequest: The URL for POST: %s\n",
                http->request->url);
            LOG(LOG_HTTP, "HTSendRequest: Content for POST: %s (%d bytes)\n",
                http->request->postdata, content_length);
        }
    }
    else
	method = "GET";

    path = strchr(http->request->url, '/')+1;
    path = strchr(path, '/')+1;
    path = strchr(path, '/')+1;


    sprintf (httpver, "HTTP/%.1f", (double)(http->request->http_protocol)/10.0);

    /*  Force all non-keep_alive requests to HTTP 1.0 so Server must close */
    /*  the connection and accrue the TIME_WAIT                            */
    if (http->request->http_protocol > 10 && !http->request->keep_alive) {
        sprintf (httpver, "HTTP/1.0");
    }

    bufp += sprintf(bufp, "%s /%s %s\r\n", method, path, httpver);
    if (http->request->http_protocol <= 10 && http->request->keep_alive) {
	bufp += sprintf(bufp, "%s\r\n", CONN_COMMAND);
    }

    if (http->request->url_type != URL_DYNAMIC_NONE) {
       bufp += sprintf(bufp, "%s\r\n%s\r\n", NOCACHE_PRAGMA, NOCACHE_CCONTROL);
    }
 
    if ( http->request->cookie_val != 0 ) {
	if ( http->request->my_cs->my_last_ad < 0 || http->request->my_cs->my_last_ad >= CADFILE_ENTRIES ) 
           http->request->my_cs->my_last_ad = (http->request->cookie_val - 10000) % CADFILE_ENTRIES;
           bufp += sprintf(bufp,"Cookie: my_cookie=user_id=%d&last_ad=%d\r\n", 
             http->request->cookie_val, http->request->my_cs->my_last_ad);
    }
    /*
     * MC: some web servers need a "Content-type:" in order to decode
     *     the POST data.
     */
     {
	char *virtual_host = http->virtual_host;
	if (virtual_host == NULL) {
	    virtual_host = http->host;
	}
    if (content_length > 0)
        bufp += sprintf(bufp, "%s\r\nHost: %s\r\nContent-Length: %d\r\n\r\n%s", 
                        ACCEPT_COMMAND_POST, virtual_host, 
                        content_length, http->request->postdata);
    else
        bufp += sprintf(bufp, "%s\r\nHost: %s\r\n\r\n", 
                        ACCEPT_COMMAND, virtual_host);
     }

LOG(LOG_HTTP, "HTSendRequest: '%s'\n", buf);

    /* Now, we are ready for sending the request */

#ifdef HTTPS_SUPPORT
    /* Write request via SSL */
    if ((status = SSL_write(http->ssl, buf, bufp-buf)) <=0) {
    if (status <= 0) {
	error = SSL_get_error(http->ssl,status);
	switch (error) {
case SSL_ERROR_NONE:
	break;
case SSL_ERROR_ZERO_RETURN: /* Socket was closed */
        LOG(LOG_HTTP|LOG_STDERR, 
        "HTSendRequest: SSL_ERROR_ZERO_RETURN: status = %d, error = %d, %s\n", 
        status, error, ERR_error_string(ERR_get_error(), NULL));
	break;
case SSL_ERROR_WANT_READ:
        LOG(LOG_HTTP|LOG_STDERR, 
        "HTSendRequest: SSL_ERROR_WANT_READ: status = %d, error = %d, %s\n", 
        status, error, ERR_error_string(ERR_get_error(), NULL));
	break;
case SSL_ERROR_WANT_WRITE:
        LOG(LOG_HTTP|LOG_STDERR, 
        "HTSendRequest: SSL_ERROR_WANT_WRITE: status = %d, error = %d, %s\n", 
        status, error, ERR_error_string(ERR_get_error(), NULL));
	break;
case SSL_ERROR_WANT_CONNECT:
        LOG(LOG_HTTP|LOG_STDERR, 
        "HTSendRequest: SSL_ERROR_WANT_CONNECT: status = %d, error = %d, %s\n", 
        status, error, ERR_error_string(ERR_get_error(), NULL));
	break;
case SSL_ERROR_WANT_X509_LOOKUP:
        LOG(LOG_HTTP|LOG_STDERR, 
     "HTSendRequest: SSL_ERROR_WANT_X509_LOOKUP: status = %d, error = %d, %s\n",
        status, error, ERR_error_string(ERR_get_error(), NULL));
	break;
case SSL_ERROR_SYSCALL:
        LOG(LOG_HTTP|LOG_STDERR, 
        "HTSendRequest: SSL_ERROR_SYSCALL: status = %d, error = %d, %s\n", 
        status, error, ERR_error_string(ERR_get_error(), NULL));
	break;
case SSL_ERROR_SSL:
        LOG(LOG_HTTP|LOG_STDERR, 
        "HTSendRequest: SSL_ERROR_SSL: status = %d, error = %d, %s\n", 
        status, error, ERR_error_string(ERR_get_error(), NULL));
	break;
default:
        LOG(LOG_HTTP|LOG_STDERR, 
        "HTSendRequest: Unsuccessful SSL_read: status = %d, error = %d, %s\n", 
        status, error, ERR_error_string(ERR_get_error(), NULL));
	break;
	
	}
    }
    status = -1;
    }

#else
    /* Now, we are ready for sending HTTP request */
    if ((status = NETWRITE(http->sockfd, buf, bufp-buf))<0) {
        LOG(LOG_HTTP|LOG_STDERR, "HTSendRequest: Can't do NETWRITE (%d)\n",
            errno);
        LOG(LOG_HTTP|LOG_STDERR, "HTSendRequest: fd=%d, len=%d, '%s'\n",
            http->sockfd, bufp-buf, buf);
    }

#endif

    return status;
}

#define VERSION_LENGTH 10
#define LINE_LENGTH 100

int HTTPGetReply (
    http_info * http
)
{
    int expect_size = 0;
#ifdef DYNAMIC_GET
    int dynamic_get = 0;
#endif
    int server_status = 0;
    int ret_count = 0;
    int len = 0;
    int content_length = 0;
    int got_content_length = 0;
    int got_HTTP10_keep_alive = 0;
    int count = 0;
    int set_cookie = 0;
    int got_set_cookie = 0;
    int found_cookie = 0;
    int found_ad_id = 0;
    int found_adweight = 0;
    int found_expired = 0;
    int got_found_cookie = 0;
    int prev_count;
    char server_version[VERSION_LENGTH];
    char *status_line = NULL;
    char *block = NULL;
    char valname[LINE_LENGTH];
    char *valchar = valname;
    int	stat_len;
    int dynamic_header_len;
    int rv, range;
    int continuing;
    int close_on_completion = 0;

    LOG(LOG_HTTP, "HTTPGetReply: access_speed = %d validate = %d\n", 
	http->request->access_speed, http->request->validate);

    do {
	continuing = errno = 0;
	status_line = HTInputSocket_getStatusLine(http, http->isoc);
	if (status_line == NULL) {
#ifdef WIN32
            int err = WSAGetLastError();
#ifndef ECONNRESET
#define ECONNRESET  WSAECONNRESET
#endif /* ECONNRESET */
#else
            int err = errno;
#endif /* WIN32 */

            /* 
             * MC: if this is a HTTP1.0 "Keep-Alive" connection, then the 
             * server may have closed its end of the socket after the 
             * previous request.  That close wouldn't be detected until 
             * this current read().  If that happened then just return 0
             * which will cause our calling function HTLoadHTTP() to close 
             * this socket, open a new one, and try this same URL again.
             */
#if 0
            if (http->request->http_protocol == 10 &&
#else
	    if (
#endif
                http->request->keep_alive && (err == 0 || err == ECONNRESET))
            {
                    LOG(LOG_HTTP, "HTTPGetReply: server closed Keep-Alive connection, opening a new one.\n");
                    http->connect = 0;
                    return 0;
            }
#ifdef WIN32 
	    if (!MC_AM_SHUTTING_DOWN)  /* MC: don't report errors on abort */
#endif /* WIN32 */
	    LOG(LOG_HTTP|LOG_STDERR, "HTTPGetReply: null status line (%d)\n",errno);
	    goto error;
	}
	LOG(LOG_HTTP, "HTTPGetReply: status line: %s\n", status_line);
	ret_count =  sscanf(status_line, "HTTP/%s %d", server_version,
	    &server_status);
	if (ret_count == 2) {
	    LOG(LOG_HTTP, "HTTPGetReply: version %s status %d\n",
		    server_version, server_status);
	    switch (server_status/100) {
		case 1:
		    continuing=1;
	            free(status_line);
		    break;
		case 2:
	            free(status_line);
		    break;
		case 3: case 4: case 5:
		default:
		    LOG(LOG_HTTP|LOG_STDERR, 
			"HTTPGetReply: Status %d for URL '%s'\n",
			server_status, http->request->url);
	            free(status_line);
		    goto error;
		    break;
	    }
	} else {
	    LOG(LOG_HTTP|LOG_STDERR, "HTTPGetReply: bad status line: '%s'\n",
	    status_line);
	    free(status_line);
	    goto error;
	}

	/* get header lines until empty line */
	while(1) {
	    status_line = HTInputSocket_getLine(http, http->isoc);
	    if (status_line == NULL){
#ifdef WIN32 
	    if (!MC_AM_SHUTTING_DOWN)  /* MC: don't report errors on abort */
#endif /* WIN32 */
		LOG(LOG_HTTP|LOG_STDERR, "HTTPGetReply: EOF before EOH (%d)\n",
		    errno);
		goto error;
	    }
	    LOG(LOG_HTTP, "HTTPGetReply: line: %s\n", status_line);

	    /*
	     * Check for "Set-Cookie:" header
	     */
            if (strncasecmp(status_line, "Set-Cookie: my_cookie=",22) == 0)
            {
		if (sscanf(&(status_line[22]), "%d", &set_cookie) > 0) {

                    /* compare the set_cookie value with the client's */
                    if (set_cookie != http->request->cookie_val) {
		        LOG(LOG_HTTP|LOG_STDERR,
			"HTTPGetReply: Bad my_cookie value:%d, expected=%d\n",
                         set_cookie, http->request->cookie_val);
	                free(status_line);
            		goto error;
                    }

		    got_set_cookie =  1;
                    LOG(LOG_HTTP, 
			"HTTPGetReply: Set_cookie: my_cookie=%d\n", set_cookie);
	        }
	    }
            if (strncasecmp(status_line, "Set-Cookie: found_cookie=",25) == 0)
            {
		got_found_cookie =  1;
                if ( sscanf(&(status_line[25]), 
		  "Ad_id=%d&Ad_weight=%2d&Expired=%1d", &found_ad_id, 
		  &found_adweight, &found_expired) > 0 ) {
                    LOG(LOG_HTTP, 
			"HTTPGetReply : Set_cookie: found_cookie=Ad_id=%3d&Ad_weight=%2d&Expired=%1d\n", found_ad_id, found_adweight, found_expired);
		    /* Validate the found_cookie returned */
		    if ( found_ad_id > CADFILE_ENTRIES || found_ad_id < 0 ) {
		        LOG(LOG_HTTP|LOG_STDERR,
			"HTTPGetReply: Ad_id in found_cookie not in range: got %d expected between 0..%d\n", found_ad_id, CADFILE_ENTRIES ) ;
	                free(status_line);
            		goto error;
		    }
		    http->request->my_cs->my_last_ad = found_ad_id;
		    if ( found_adweight > MAX_CAD_WEIGHT ) {
			LOG(LOG_HTTP|LOG_STDERR,
			"HTTPGetReply: Ad_weight in found_cookie not in range: got %d expected %d or under\n", found_adweight, MAX_CAD_WEIGHT ) ;
	                free(status_line);
		        goto error;
		    }
		    if ( found_expired == 1 ) {
			range = -1;
			if      (found_ad_id <= http->request->my_cs->load.expired_ads_range_high[0]) range = 0;
			else if (found_ad_id <= http->request->my_cs->load.expired_ads_range_high[1]) range = 1;
			else if (found_ad_id <= http->request->my_cs->load.expired_ads_range_high[2]) range = 2;
			if ((range != -1) && found_ad_id < http->request->my_cs->load.expired_ads_range_low[range]) {
			  LOG(LOG_HTTP|LOG_STDERR,
"HTTPGetReply: Invalid Expired Ad for %d in %d : %d\n", found_ad_id, http->request->my_cs->load.expired_ads_range_low[range], http->request->my_cs->load.expired_ads_range_high[range]);
			 /* "HTTPGetReply: Invalid Expired Ad in found_cookie\n");*/
	                  free(status_line);
			  goto error;
			}
		    } else { /* found_expired == 0 */
			range = -1;
			if ( found_ad_id < http->request->my_cs->load.expired_ads_range_high[0]) range = 0;
			else if (found_ad_id < http->request->my_cs->load.expired_ads_range_high[1]) range = 1;
			else if (found_ad_id < http->request->my_cs->load.expired_ads_range_high[2]) range = 2;
			if ( (range != -1) && found_ad_id >= http->request->my_cs->load.expired_ads_range_low[range]) {
			 LOG(LOG_HTTP|LOG_STDERR,
"HTTPGetReply: Expected Expired Ad for %d in %d : %d\n", found_ad_id, http->request->my_cs->load.expired_ads_range_low[range], http->request->my_cs->load.expired_ads_range_high[range]);
			 /*"HTTPGetReply: Expected Expired Ad in found_cookie\n");*/
	                  free(status_line);
			  goto error;
			}
		    }
	        }
		else {
                    LOG(LOG_HTTP|LOG_STDERR, 
			"HTTPGetReply: Bad  Set_cookie: found_cookie=%s\n", &(status_line[25])); 
	            free(status_line);
		    goto error;
		}
	    }

            /*
             * If we get a "Connection: close" header then close
	     * this socket after this response is finished.
	     */

            if (strncasecmp(status_line, "Connection: close", 17) == 0)
                close_on_completion = 1;

            if ((http->request->http_protocol == 10) &&
                http->request->keep_alive && (got_HTTP10_keep_alive == 0) )
            {
               /** HTTP/1.0 Response must contain Keep-Alive header
                ** to maintain keep_alive
               */
               if (strncasecmp(status_line, "Connection: Keep-Alive", 22) == 0)
                  got_HTTP10_keep_alive = 1;
            }

	    /*
	    * MC: various servers use both "Content-Length" and "Content-length"
	    */
	    if (strncasecmp(status_line, "Content-Length:", 15) == 0)
	    {
		if (sscanf(&(status_line[15]), "%d", &content_length) > 0) { 
		    got_content_length = 1;
		    LOG(LOG_HTTP, "HTTPGetReply: content_length: %d\n",
			content_length);
		}
	    }
	    if (*status_line == '\0'){
		LOG(LOG_HTTP, "HTTPGetReply: empty line\n");
		free(status_line);
		break;
	    }
	    free(status_line);
	}

        if ( !continuing && http->request->validate && http->request->url_type == URL_DYNAMIC_COOKIE ) {
           if (got_found_cookie == 0) {
	       LOG(LOG_HTTP|LOG_STDERR, "HTTPGetReply: Get for URL_DYNAMIC_COOKIE failed to return found_cookie header\n");
               goto error;
           }
        }
        if ( !continuing && http->request->validate && http->request->url_type == URL_DYNAMIC_POST ) {
           if (got_set_cookie == 0) {
               LOG(LOG_HTTP|LOG_STDERR,
               "HTTPGetReply: Post failed to return my_cookie header\n");
               goto error;
           }
        }
    } while (continuing);

    if ((http->request->http_protocol == 10) &&
        http->request->keep_alive && (got_HTTP10_keep_alive == 0) )
    {
        close_on_completion = 1;
	LOG(LOG_HTTP, "HTTPGetReply: Close HTTP/1.0 KA as per response\n");
    }

    if (http->request->validate) {
	/* get the expected file size & file name from the first line of the file */
        status_line = HTInputSocket_getLine(http, http->isoc);
        if (status_line == NULL){
#ifdef WIN32 
          if (!MC_AM_SHUTTING_DOWN)  /* MC: don't report errors on abort */
#endif /* WIN32 */
	    LOG(LOG_HTTP|LOG_STDERR, 
		"HTTPGetReply: URL contains no data (%d)\n", errno);
            goto error;
        }

	dynamic_header_len = 0;
#ifdef DYNAMIC_GET
	if (strcmp(status_line,"<html>")==0) {
	    dynamic_get = 1;
	    dynamic_header_len += strlen(status_line)+1;
	    free(status_line); 		/* <- Added missing free */    
	    while(1) {
		status_line = HTInputSocket_getLine(http, http->isoc);
#ifdef WIN32
                if (status_line == NULL) /*MC: abort */
                    goto error;
#endif /* WIN32 */
		dynamic_header_len += strlen(status_line)+1;

                if (strcmp(status_line,"<pre>")==0) {
		    free(status_line);
		    break;
		}

if ( http->request->validate && http->request->url_type != URL_DYNAMIC_POST ) {
                if (strncmp(status_line,"<p>QUERY_STRING", 15)==0) {
                 if (NULL==strstr(status_line, http->request->fileset_url)){
	             LOG(LOG_HTTP|LOG_STDERR, "HTTPGetReply: bad QUERY: '%s'\n",
		         status_line);
		     free(status_line);
                     goto error;
                 }
                }
}
	    if (*status_line == '\0'){
		LOG(LOG_HTTP|LOG_STDERR, "HTTPGetReply: empty line\n");
		free(status_line);
		break;
	    }
		free(status_line);
	    }
	    status_line = HTInputSocket_getLine(http, http->isoc);
#ifdef WIN32
            if (status_line == NULL) /*MC: abort */
                goto error;
#endif /* WIN32 */
	}
#endif

	LOG(LOG_HTTP, "HTTPGetReply: size line: %s\n", status_line);
        ret_count =  sscanf(status_line, "%d %s", &expect_size, valname);
	stat_len = strlen(status_line)+1;
        if (ret_count != 2) {
	    LOG(LOG_HTTP|LOG_STDERR, "HTTPGetReply: bad size line: '%s'\n",
		status_line);
	    free(status_line);
    	    goto error;
        }
	free(status_line);
	LOG(LOG_HTTP, "HTTPGetReply: validate url = %s\n", valname);
	LOG(LOG_HTTP, "HTTPGetReply: expect_size %d\n", expect_size);
        if (expect_size != http->request->file_size) {
            LOG(LOG_HTTP|LOG_STDERR,
                "HTTPGetReply: bad file size: expected=%d, returned=%d\n",
                http->request->file_size, expect_size);
            goto error;
        }
        if (0 != strcmp(valname, http->request->fileset_url)) {
            LOG(LOG_HTTP|LOG_STDERR,
                "HTTPGetReply: bad url name: requested=%s, returned=%s\n",
                http->request->fileset_url, valname);
            goto error;
        }
    }

#ifdef DYNAMIC_GET
/* 
 * to account for the extra 23 characters that are transferred in the
 * dynamic GET case
 */
    if (dynamic_get) {
       expect_size = expect_size+23;
    }
#endif

#define CHUNKSIZE 4096
/* assumes that the maximum block read (INPUT_BUFFER_SIZE) 
 * is <= the verification interval (CHUNKSIZE)
 */
    prev_count = CHUNKSIZE-1;
    while (1) {
        len = INPUT_BUFFER_SIZE;
        block = HTInputSocket_getBlock(http, http->isoc, &len);
        count += len;
	LOG(LOG_HTTP, "HTTPGetReply: got %d bytes\n", len);
        LOG(LOG_HTTP, 
            "HTTPGetReply: got content_length=%d, stat_len=%d, dynamic_header_len=%d, count=%d, len=%d, \n", 
            content_length, stat_len, dynamic_header_len, count, len);

        if (block == NULL) {
#ifdef WIN32
            if (MC_AM_SHUTTING_DOWN)
                goto error; /*MC: abort */
#endif /* WIN32 */
            break;
        }

	if (http->request->validate &&
	    prev_count+len >= CHUNKSIZE) {

	    if (*valchar++ == block[(CHUNKSIZE-1)-prev_count]) {
						/* Check if match validates */
		if (*valchar == '\0') {		/* check for end of string */
		    valchar = valname;		/* if so, start over again */
		}
	    } else {				/* block does not match url */
		LOG(LOG_HTTP|LOG_STDERR, 
		    "HTTPGetReply: mismatch '%c' (%d) != '%c' (%d)\n",
		    (int)(*valchar),(int)(*valchar),
		    (int)(block[0]), (int)(block[0]));
		goto error;			/* a fetch error */
	    }
	    prev_count -= CHUNKSIZE;
	}
	prev_count += len;
#define CLOSE_ON_COUNT /*KA: was #define CLOSE_ON_COUNT 1 */
#ifdef CLOSE_ON_COUNT
	if (got_content_length) {
#else
        if (http->connect > 0) {
#endif /* CLOSE_ON_COUNT */
	    if (count+stat_len+dynamic_header_len == content_length) {
                break;
            }
        }
    }

    count += stat_len;
    LOG(LOG_HTTP, "HTTPGetReply: count %d\n", count);

    if (http->request->validate && (count != expect_size)) {
	LOG(LOG_HTTP|LOG_STDERR, "HTTPGetReply: got %d, expected %d\n",
	    count, expect_size);

        goto error;
    }

    if (close_on_completion)
        http->connect = 0;
    rv = 1;
    goto exit;

error:
	/*
	 * MC: KA - If we got an error on this connection then we should 
	 * close it regardless of its keep-alive status.
	 */
       http->connect = 0; 
    rv = -1;
exit:
    return rv;
}


int HTTPCleanup (http_info * http)
{
    int status = 0;



#ifdef HTTPS_SUPPORT
  LOG(LOG_HTTP, "HTTPCleanup: STATE=%d, Connect=%d\n", http->request->my_cs->state.mode, http->connect);

    if ( http->connect > 0) {
        if ( http->request->my_cs->state.mode == CS_SHUTDOWN ) {
          if ((status = NETCLOSE(http->sockfd)) < 0){
            LOG(LOG_HTTP|LOG_STDERR, "HTTPCleanup: close error (%d)\n", errno);
          }
        } 
	return 1;
    } 
    http->connect = 0;


    /* send close-notify to server, mark session as closed (but available 
       for reuse) -- if we successfully opened a session in the 1st place */
    if (http->ssl) 
	    status = SSL_shutdown(http->ssl);
	switch (status) {
case -1:
        LOG(LOG_HTTP|LOG_STDERR,
          "HTTPCleanup: SSL_shutdown case -1, status: %d, %s\n",
            status, ERR_error_string(ERR_get_error(), NULL));
default:
	break;

        }

        if ( http->request->my_cs->state.mode == CS_SHUTDOWN ) {
          if ((status = NETCLOSE(http->sockfd)) < 0){
            LOG(LOG_HTTP|LOG_STDERR, "HTTPCleanup: close error (%d)\n", errno);
          }
        } 


#else
    if (http->connect > 0) {
	return 1;
    } 
    http->connect = 0;

    if ((status = NETCLOSE(http->sockfd)) < 0){
        LOG(LOG_HTTP|LOG_STDERR, "HTTPCleanup: close error (%d)\n", errno);
    }

#endif

    LOG(LOG_HTTP, "HTTPClose: fd=%d\n", http->sockfd);

    return status;
}

PRIVATE char * method_names[(int)MAX_METHODS + 1] =
{
    "INVALID-METHOD",
    "GET",
    "HEAD",
    "POST",
    "PUT",
    "DELETE",
    "CHECKOUT",
    "CHECKIN",
    "SHOWMETHOD",
    "LINK",
    "UNLINK",
    NULL
};

PUBLIC HTMethod HTMethod_enum ARGS1(char *, name)
{
    if (name) {
        int i;
        for (i=1; i < (int)MAX_METHODS; i++)
            if (!strcmp(name, method_names[i]))
                return (HTMethod)i;
    }
    return METHOD_INVALID;
}
 
 
/*      Get method name
**      ---------------
*/
PUBLIC char * HTMethod_name ARGS1(HTMethod, method)
{
    if ((int)method > (int)METHOD_INVALID  &&
        (int)method < (int)MAX_METHODS)
        return method_names[(int)method];
    else
        return method_names[(int)METHOD_INVALID];
}
/*
 * host_port is of the form host:port or just host
 */
static void
get_host_port(
    char *host_port,
    char **host,
    int *port
)
{
    char *p;
 
    *host = (char *) strdup(host_port);
    p = strchr(*host, ':');
    if (p == NULL) {
        *port = -1;
        return;
    } else {
        *p = '\0';
        p++;
        *port = atoi(p);
    }
}

#ifdef EXPLICIT_BIND
#define MINPORT 5001L	    /* lowest port number to assign */
#define MAXPORT 65000L	    /* highest port number to assign */

/* Assign a port number to an unbounded socket
   Each child gets its own unique range of port number via % operation

   Return -1 for failure, otherwise the number of extra sockets checked
 */
static int assign_port_number(http_info * http) {
#ifdef WIN32
SOCKADDR_IN sin; 
#else
struct sockaddr_in sin;
#endif /* WIN32 */
u_short port;
int i;

    sin.sin_family = AF_INET; 

    if (strcmp(options.IPAddress,"INADDR_ANY") != 0) {
       /*gmc: new way - listen only for a specific ipaddress */
       sin.sin_addr.s_addr =  inet_addr(options.IPAddress);
    } else {
       /*gmc: old way - accept from any ip address */
       sin.sin_addr.s_addr = 0;
    }

    for (i = 0; i <= http->numport; i++) { 
	port = (u_short)(http->currentport++);
	if (http->currentport >= http->startport + http->numport)
	    http->currentport = http->startport;
	sin.sin_port = htons(port); 
LOG(LOG_HTTP, "assign_port_number: attempting %d: ", port);
#ifdef WIN32
	if (bind(http->sockfd, (LPSOCKADDR)&sin, sizeof (sin)) == 0) { 
#else
/*	if (bind(http->sockfd, (struct sockaddr_in *)&sin, sizeof (sin)) == 0) {  */
	if (bind(http->sockfd, (struct sockaddr *)&sin, sizeof (sin)) == 0) { 
#endif /* WIN32 */
	    /* port assignment worked */ 
LOG(LOG_HTTP, "ok\n");
	    return i;
	} 
LOG(LOG_HTTP, "errno = %d\n", errno);
#ifdef WIN32
	if ( GetLastError() != WSAEADDRINUSE) { 
#else
	if (errno != EADDRINUSE) {
#endif /* WIN32 */
	    /* fail from cause other than lack of a port */ 
	    return -1;
	} 
    } 
    /* fail--all port numbers are in use */ 
    return -1;
} 
#endif /* EXPLICIT_BIND */


